CREATE TABLE #T_RESTORE_HEADERONLY_2012
(BackupName              nvarchar(128),
BackupDescription        nvarchar(255),
BackupType               smallint,
ExpirationDate           datetime,
Compress                bit, --  partir de la version 2008
Position                 smallint,
DeviceType               tinyint,
UserName                 nvarchar(128),
ServerName               nvarchar(128),
DatabaseName             nvarchar(128),
DatabaseVersion          int,
DatabaseCreationDate     datetime,
BackupSize               numeric(20,0),
FirstLSN                 numeric(25,0),
LastLSN                  numeric(25,0),
CheckpointLSN            numeric(25,0),
DatabaseBackupLSN        numeric(25,0),
BackupStartDate          datetime,
BackupFinishDate         datetime,
SortOrder                smallint,
CodePage                 smallint,
UnicodeLocaleId          int,
UnicodeComparisonStyle   int,
CompatibilityLevel       tinyint,
SoftwareVendorId         int,
SoftwareVersionMajor     int,
SoftwareVersionMinor     int,
SoftwareVersionBuild     int,
MachineName              nvarchar(128),
Indicateurs              int,
BindingID                uniqueidentifier,
RecoveryForkID           uniqueidentifier,
Collation                nvarchar(128),
FamilyGUID               uniqueidentifier,
HasBulkLoggedData        bit,
IsSnapshot               bit,
IsReadOnly               bit,
IsSingleUser             bit,
HasBackupChecksums       bit,
IsDamaged                bit,
BeginsLogChain           bit,
HasIncompleteMetaData    bit,
IsForceOffline           bit,
IsCopyOnly               bit,
FirstRecoveryForkID      uniqueidentifier,
ForkPointLSN             numeric(25,0),
RecoveryModel            nvarchar(60),
DifferentialBaseLSN      numeric(25,0),
DifferentialBaseGUID     uniqueidentifier,
BackupTypeDescription    nvarchar(60),
BackupSetGUID            uniqueidentifier,
CompressedBackupSize     bigint, --  partir de la version 2008
Containement             bit --  partir de la version 2012
);
GO

INSERT INTO #T_RESTORE_HEADERONLY_2012
EXEC ('RESTORE HEADERONLY FROM DISK = ''C:\Databases\SAVE\TEST_LSN.bak'';');
GO

INSERT INTO #T_RESTORE_HEADERONLY_2012
EXEC ('RESTORE HEADERONLY FROM DISK = ''C:\Databases\SAVE\TEST_LSN.trn'';');
GO